%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
% mfile to solve of "Integrated design with UIO"
% Jianglin Lan, 2015-0903, function file
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function sys_state = FTC_closed_sys_performance(t,xx,A,B,Fa,D,C,Fs,Delta_A,Kx,M,G,L,H)
hat_eta = xx(1);
xi1 = xx(2);
xi2 = xx(3);
xi3 = xx(4);
xi4 = xx(5);
x1 = xx(6);
x2 = xx(7);

global Int_s1 Int_ffa Int_ffs Int_yy1 Int_yy2 Int_ts Int_count Int_tmp Int_hatfa Int_hatfs Int_s


E = pinv(B)*Fa;

Y = 0.5*ones(1,2);
N = pinv(C*B) - Y * (eye(2) - C*B*pinv(C*B));

psi = 0.001; omega =  16.4073; 
phi = omega*psi + 0.01;

varep1 = 0.01; varep2 = 1.0e-3; 
sigma = 0.1;

Ko = [11.7376    6.7797];

H = [     0.9758    0.4850
   -0.0082   -0.0066
    2.4468    0.5791
    0.0031    0.4987];

G = [     0.4835
    0.1648
  -48.9369
   -0.0625];

M = [    -2.2724    0.4896    0.0483   -1.0528
    1.1040   -3.3947    0.0165    1.0407
   -1.2674    1.4827   -4.8937   -0.9071
   -0.2560    1.3850   -0.0062   -1.4006];

L = [    -2.5665   -1.3059
    4.3142    2.1486
   44.1958   25.2536
   -2.1632   -1.0762];


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% disturbance and fault
d = 0.01 * sin(t);
fa = piecewise_fa(t); 
fs = piecewise_fs(t); % 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
x = [x1;x2];
y = C*x + Fs*fs;
xi = [xi1;xi2;xi3;xi4];
hat_x = xi + H*y;

% sliding surface
yc = y - Fs*hat_x(4);
s_t = N*yc;

% controller
u_l = - [Ko E 0]*hat_x;
rho2 = hat_eta + varep1 + phi;

u_n = -rho2 * (s_t / (norm(s_t,2) + varep2));

u = u_l + u_n;

dot_hat_eta = sigma * norm(s_t,2);

%observer
dot_xi = M* xi + G*u + L*y;

% sys dynamic
dot_x = (A + Delta_A)*x + B*u + Fa*fa + D*d;


% data saving 
if mod(Int_tmp,2)==0
    Int_count = Int_count + 1;
Int_ts(Int_count) = t;
Int_ffa(Int_count) = fa;
Int_ffs(Int_count) = fs;
Int_yy1(Int_count) = yc(1);
Int_yy2(Int_count) = yc(2);
Int_s1(Int_count) = s_t;
Int_hatfa(Int_count) = fa - hat_x(3);
Int_hatfs(Int_count) = fs - hat_x(4);
Int_s(Int_count) = u;
end
Int_tmp = Int_tmp + 1;

sys_state = [dot_hat_eta;dot_xi;dot_x];